/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.ICoverable;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.Cover;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.cover.CoverType;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.item.info.IItemInfo;
import com.raoulvdberge.refinedstorage.item.info.ItemInfo;
import com.raoulvdberge.refinedstorage.render.IModelRegistration;
import com.raoulvdberge.refinedstorage.render.model.loader.CustomModelLoaderCover;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCover
extends ItemBase {
    private static final String NBT_ITEM = "Item";
    public static final ItemStack HIDDEN_COVER_ALTERNATIVE = new ItemStack(Blocks.field_150417_aV);

    public ItemCover(IItemInfo info) {
        super(info);
        this.func_77637_a(RS.INSTANCE.coversTab);
    }

    public ItemCover() {
        this(new ItemInfo("refinedstorage", "cover"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(IModelRegistration modelRegistration) {
        modelRegistration.setModel(this, 0, new ModelResourceLocation(this.info.getId(), "inventory"));
        modelRegistration.addModelLoader(CustomModelLoaderCover::new);
    }

    public static void setItem(ItemStack cover, ItemStack item) {
        if (!cover.func_77942_o()) {
            cover.func_77982_d(new NBTTagCompound());
        }
        cover.func_77978_p().func_74782_a(NBT_ITEM, (NBTBase)item.serializeNBT());
    }

    @Nonnull
    public static ItemStack getItem(ItemStack cover) {
        if (!cover.func_77942_o() || !cover.func_77978_p().func_74764_b(NBT_ITEM)) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cover.func_77978_p().func_74775_l(NBT_ITEM));
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        ItemStack item = ItemCover.getItem(stack);
        if (!item.func_190926_b()) {
            tooltip.add(item.func_77973_b().func_77653_i(item));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        if (RS.INSTANCE.config.hideCovers) {
            ItemStack stack = new ItemStack((Item)this);
            ItemCover.setItem(stack, HIDDEN_COVER_ALTERNATIVE);
            items.add((Object)stack);
            return;
        }
        for (Block block : Block.field_149771_c) {
            Item item = Item.func_150898_a((Block)block);
            if (item == Items.field_190931_a) continue;
            NonNullList subBlocks = NonNullList.func_191196_a();
            block.func_149666_a(CreativeTabs.field_78027_g, subBlocks);
            for (ItemStack subBlock : subBlocks) {
                if (!CoverManager.isValidCover(subBlock)) continue;
                ItemStack stack = new ItemStack((Item)this);
                ItemCover.setItem(stack, subBlock);
                items.add((Object)stack);
            }
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (!this.canPlaceOn(tile)) {
            pos = pos.func_177984_a();
            facing = EnumFacing.DOWN;
            tile = world.func_175625_s(pos);
        }
        if (this.canPlaceOn(tile)) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            INetworkNode node = ((TileNode)tile).getNode();
            if (node.getNetwork() != null && !node.getNetwork().getSecurityManager().hasPermission(Permission.BUILD, player)) {
                WorldUtils.sendNoPermissionMessage(player);
                return EnumActionResult.FAIL;
            }
            if (((ICoverable)((Object)node)).getCoverManager().setCover(facing, this.createCover(ItemCover.getItem(stack)))) {
                player.func_184586_b(hand).func_190918_g(1);
                WorldUtils.updateBlock(world, pos);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    private boolean canPlaceOn(TileEntity tile) {
        return tile instanceof TileNode && ((TileNode)tile).getNode() instanceof ICoverable;
    }

    protected Cover createCover(ItemStack stack) {
        return new Cover(stack, CoverType.NORMAL);
    }
}

